<?php

wp_enqueue_style('custom-slider-tab-css', plugin_dir_url(__FILE__) . '../assets/css/tab.css', array(), '1.0.0', 'all');
?>


<div class="wrap">
  <h1><?php echo esc_html__('Welcome to Ovation Elements Plugin!', 'ovation-elements'); ?></h1>
  <p>
    <?php echo esc_html__('The Ovation Elements Plugin is designed to simplify the process of creating and customizing various website elements, offering an intuitive and powerful toolset for WordPress users of all levels. With our plugin, you can easily create stunning sliders, custom post types, and page templates, all optimized for seamless integration with popular page builders like Elementor, Divi, and Gutenberg.', 'ovation-elements'); ?>
  </p>
  <!-- Add more dashboard content here -->
</div>


<body>
  <div class="grid-container ov-feature-outer">
    <?php
    $plugin_url = plugins_url('../assets/images/', __FILE__);
    ?>
    <div class="grid-item">
      <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="95.679" height="89.842"
        viewBox="0 0 95.679 89.842">
        <defs>
          <linearGradient id="linear-gradient" x1="0.5" x2="0.5" y2="1" gradientUnits="objectBoundingBox">
            <stop offset="0" stop-color="#1228c7" />
            <stop offset="1" stop-color="#f45af2" />
          </linearGradient>
        </defs>
        <g id="Group_26" data-name="Group 26" transform="translate(-9.999 -25.005)">
          <g id="Group_25" data-name="Group 25" transform="translate(68.924 75.257)">
            <path id="Path_69" data-name="Path 69"
              d="M313.012,346.031a1.167,1.167,0,1,0,2.334,0v-5.445a1.167,1.167,0,0,0-2.334,0Z"
              transform="translate(-313.012 -328.529)" fill="url(#linear-gradient)" />
            <path id="Path_70" data-name="Path 70"
              d="M313.012,402.031a1.167,1.167,0,0,0,2.334,0v-5.445a1.167,1.167,0,0,0-2.334,0Z"
              transform="translate(-313.012 -373.639)" fill="url(#linear-gradient)" />
            <path id="Path_71" data-name="Path 71"
              d="M314.179,291.2a1.167,1.167,0,0,0,1.167-1.167v-5.445a1.167,1.167,0,1,0-2.334,0v5.445A1.167,1.167,0,0,0,314.179,291.2Z"
              transform="translate(-313.012 -283.419)" fill="url(#linear-gradient)" />
          </g>
          <path id="Path_72" data-name="Path 72"
            d="M340.924,348.146a1.167,1.167,0,0,0,1.167,1.167h23.435a1.167,1.167,0,0,0,0-2.334H342.091A1.167,1.167,0,0,0,340.924,348.146Z"
            transform="translate(-266.572 -259.361)" fill="url(#linear-gradient)" />
          <path id="Path_73" data-name="Path 73"
            d="M342.091,389.246h23.435a1.167,1.167,0,0,0,0-2.334H342.091a1.167,1.167,0,0,0,0,2.334Z"
            transform="translate(-266.572 -291.529)" fill="url(#linear-gradient)" />
          <path id="Path_74" data-name="Path 74"
            d="M342.091,429.179h23.435a1.167,1.167,0,0,0,0-2.334H342.091a1.167,1.167,0,0,0,0,2.334Z"
            transform="translate(-266.572 -323.696)" fill="url(#linear-gradient)" />
          <path id="Path_75" data-name="Path 75"
            d="M424.18,265.458a2.211,2.211,0,0,0,2.209-2.209v-7.936a2.211,2.211,0,0,0-2.209-2.209h-7.943a2.211,2.211,0,0,0-2.209,2.209v7.936a2.211,2.211,0,0,0,2.209,2.209Zm-7.818-10.019h7.692v7.686h-7.692Z"
            transform="translate(-325.46 -183.743)" fill="url(#linear-gradient)" />
          <path id="Path_76" data-name="Path 76"
            d="M105.191,53.678a5.02,5.02,0,0,0-2.863-2.6L30.4,25.3a5.059,5.059,0,0,0-6.461,3.047L10.3,66.359a5.049,5.049,0,0,0,3.05,6.458l4.678,1.677v23.04a1.167,1.167,0,1,0,2.334,0V69.418A2.717,2.717,0,0,1,23.075,66.7H68.924v4.278a1.167,1.167,0,1,0,2.334,0V66.7H99.492a2.717,2.717,0,0,1,2.717,2.717V109.8a2.717,2.717,0,0,1-2.717,2.717H71.258v-3.419a1.167,1.167,0,1,0-2.334,0v3.419H23.075a2.717,2.717,0,0,1-2.717-2.717v-2.539a1.167,1.167,0,0,0-2.334,0V109.8a5.051,5.051,0,0,0,5.051,5.051H99.492a5.051,5.051,0,0,0,5.051-5.051V69.418a5.041,5.041,0,0,0-1.988-4.015l2.822-7.864a5.015,5.015,0,0,0-.186-3.861ZM51.238,64.367,24.154,54.66a.774.774,0,0,1-.468-.99l6.863-19.122a.778.778,0,0,1,.993-.468l32.85,11.774a.774.774,0,0,1,.468.99L58.571,64.367Zm45.365,0h-1.71l-5.722-2.051,2.6-7.234,7.241,2.6Zm6.579-7.616-2.765,7.7a5.063,5.063,0,0,0-.924-.086h-.409l2.164-6.02a2.208,2.208,0,0,0-1.334-2.824l-7.476-2.68a2.212,2.212,0,0,0-2.825,1.333l-2.681,7.47a2.205,2.205,0,0,0,1.094,2.721H67.566L68,63.155a1.167,1.167,0,0,0-2.2-.789l-.718,2H61.05l6.005-16.735a3.108,3.108,0,0,0-1.877-3.975L32.328,31.883a3.114,3.114,0,0,0-3.976,1.876L21.489,52.881a3.108,3.108,0,0,0,1.877,3.976l20.956,7.51H23.075a5.051,5.051,0,0,0-5.051,5.051v2.6l-3.89-1.395a2.715,2.715,0,0,1-1.641-3.473l13.642-38.01a2.723,2.723,0,0,1,3.477-1.64L72.768,42.965l-1.445,4.025a1.167,1.167,0,1,0,2.2.789l1.445-4.027,26.576,9.525a2.715,2.715,0,0,1,1.641,3.473Z"
            fill="url(#linear-gradient)" />
          <path id="Path_77" data-name="Path 77"
            d="M309.474,160.515a1.167,1.167,0,0,0-1.492.7l-1.839,5.125a1.167,1.167,0,0,0,2.2.789l1.839-5.125A1.167,1.167,0,0,0,309.474,160.515Z"
            transform="translate(-238.499 -109.102)" fill="url(#linear-gradient)" />
          <path id="Path_78" data-name="Path 78"
            d="M133.544,127.086a2.82,2.82,0,0,0-3.787-1.883l-5.731,1.939-2.071-7.222a2.82,2.82,0,0,0-4.29-1.557l-8.278,5.6a2.812,2.812,0,0,0,.633,4.976l21.505,7.709a2.813,2.813,0,0,0,3.671-3.369Zm-.739,7.271a.467.467,0,0,1-.492.1l-21.505-7.709a.465.465,0,0,1-.317-.394.457.457,0,0,1,.206-.453l8.277-5.6a.469.469,0,0,1,.267-.084.505.505,0,0,1,.171.03.474.474,0,0,1,.3.321l2.4,8.385.007.025.18.63a1.167,1.167,0,0,0,2.281-.185l5.958-2.016q.044-.015.086-.033a.486.486,0,0,1,.661.32l1.653,6.2a.458.458,0,0,1-.137.472Z"
            transform="translate(-79.067 -74.813)" fill="url(#linear-gradient)" />
          <path id="Path_79" data-name="Path 79"
            d="M188.962,126.355a3.518,3.518,0,1,0-2-1.809A3.518,3.518,0,0,0,188.962,126.355Zm.067-3.71a1.191,1.191,0,0,1,2.195-.1,1.171,1.171,0,0,1,.045.9,1.191,1.191,0,0,1-2.195.1,1.17,1.17,0,0,1-.045-.9Z"
            transform="translate(-142.28 -76.138)" fill="url(#linear-gradient)" />
          <path id="Path_80" data-name="Path 80"
            d="M120.039,255.933h-34.9a3.111,3.111,0,0,0-3.109,3.109v20.313a3.112,3.112,0,0,0,3.109,3.109h34.9a3.112,3.112,0,0,0,3.109-3.109V259.042A3.111,3.111,0,0,0,120.039,255.933Zm.775,23.422a.776.776,0,0,1-.775.775h-34.9a.776.776,0,0,1-.775-.775V259.042a.776.776,0,0,1,.775-.775h34.9a.776.776,0,0,1,.775.775Z"
            transform="translate(-58.023 -186.021)" fill="url(#linear-gradient)" />
          <path id="Path_81" data-name="Path 81"
            d="M123.313,410.973H84.752a1.167,1.167,0,1,0,0,2.334h38.563a1.167,1.167,0,0,0,0-2.334Z"
            transform="translate(-59.276 -310.911)" fill="url(#linear-gradient)" />
          <path id="Path_82" data-name="Path 82"
            d="M123.313,443.916H84.752a1.167,1.167,0,0,0,0,2.334h38.563a1.167,1.167,0,1,0,0-2.334Z"
            transform="translate(-59.276 -337.447)" fill="url(#linear-gradient)" />
          <path id="Path_83" data-name="Path 83"
            d="M139.861,299.6a2.821,2.821,0,0,0-4.2-.5l-4.74,3.759-4.389-6.1a2.827,2.827,0,0,0-2.278-1.172h-.01a2.828,2.828,0,0,0-2.275,1.154l-5.9,8.068a2.812,2.812,0,0,0,2.275,4.47h22.847a2.812,2.812,0,0,0,2.318-4.41Zm1.761,7.094a.467.467,0,0,1-.429.258H118.346a.467.467,0,0,1-.433-.264.457.457,0,0,1,.041-.494l5.9-8.068a.476.476,0,0,1,.392-.2h0a.475.475,0,0,1,.392.2l5.493,7.633a1.167,1.167,0,0,0,2.084-.944l4.927-3.907c.024-.019.047-.039.07-.06a.486.486,0,0,1,.731.078l3.65,5.275A.458.458,0,0,1,141.623,306.692Z"
            transform="translate(-85.009 -217.967)" fill="url(#linear-gradient)" />
          <path id="Path_84" data-name="Path 84"
            d="M184.746,290.66a3.5,3.5,0,1,0-2.495-1.023A3.514,3.514,0,0,0,184.746,290.66Zm-.843-4.351a1.191,1.191,0,0,1,2.032.835,1.171,1.171,0,0,1-.347.835,1.191,1.191,0,0,1-2.032-.835,1.171,1.171,0,0,1,.347-.835Z"
            transform="translate(-137.927 -208.333)" fill="url(#linear-gradient)" />
          <path id="Path_85" data-name="Path 85"
            d="M28.243,338.436h-.007a1.167,1.167,0,0,0-1.167,1.16l-.1,16.838a1.167,1.167,0,0,0,1.16,1.174h.007a1.167,1.167,0,0,0,1.167-1.16l.1-16.838A1.167,1.167,0,0,0,28.243,338.436Z"
            transform="translate(-13.67 -252.48)" fill="url(#linear-gradient)" />
          <path id="Path_86" data-name="Path 86"
            d="M28.854,290.238h-.008a1.167,1.167,0,0,0-1.167,1.159l-.032,4.777a1.167,1.167,0,0,0,1.159,1.175h.008a1.167,1.167,0,0,0,1.167-1.159l.032-4.777A1.167,1.167,0,0,0,28.854,290.238Z"
            transform="translate(-14.216 -213.655)" fill="url(#linear-gradient)" />
        </g>
      </svg>

      <h2>Multiple Slider Templates</h2>
    </div>
    <div class="grid-item">
      <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="116" height="88.828"
        viewBox="0 0 116 88.828">
        <defs>
          <linearGradient id="linear-gradient" x1="0.5" x2="0.5" y2="1" gradientUnits="objectBoundingBox">
            <stop offset="0" stop-color="#1228c7" />
            <stop offset="1" stop-color="#f45af2" />
          </linearGradient>
        </defs>
        <path id="Path_87" data-name="Path 87"
          d="M61.19,132.933a1.586,1.586,0,0,1-.678,2.138,33.692,33.692,0,0,1-4.318,1.866l-2.488,11.005a1.586,1.586,0,0,1-1.547,1.237H37.678a1.586,1.586,0,0,1-1.547-1.237l-2.488-11.005a34.184,34.184,0,0,1-3.5-1.456L20.6,141.5a1.587,1.587,0,0,1-1.968-.22L8.39,131.047a1.586,1.586,0,0,1-.22-1.969l6.028-9.539a34.253,34.253,0,0,1-1.455-3.5L1.738,113.549A1.586,1.586,0,0,1,.5,112V97.52a1.586,1.586,0,0,1,1.237-1.547l11.005-2.488a34.913,34.913,0,0,1,1.45-3.5L8.17,80.443a1.586,1.586,0,0,1,.22-1.969L18.633,68.238a1.586,1.586,0,0,1,1.968-.22l9.539,6.022a33.552,33.552,0,0,1,3.5-1.452l2.487-11a1.586,1.586,0,0,1,1.547-1.237H52.159a1.586,1.586,0,0,1,1.547,1.237l2.487,11a33.183,33.183,0,0,1,3.5,1.451l9.544-6.022a1.586,1.586,0,0,1,1.968.22L81.441,78.475a1.587,1.587,0,0,1,.22,1.968l-6.022,9.544a33.131,33.131,0,0,1,1.451,3.5l2.994.676a1.586,1.586,0,0,1-.7,3.094l-3.866-.874a1.586,1.586,0,0,1-1.162-1.066,29.909,29.909,0,0,0-1.945-4.689,1.586,1.586,0,0,1,.067-1.577L78.3,79.822l-8.444-8.444L60.628,77.2a1.586,1.586,0,0,1-1.576.067,29.98,29.98,0,0,0-4.69-1.945A1.586,1.586,0,0,1,53.3,74.16l-2.4-10.638H38.945L36.54,74.16a1.586,1.586,0,0,1-1.066,1.162,30.294,30.294,0,0,0-4.7,1.947A1.588,1.588,0,0,1,29.2,77.2l-9.223-5.823-8.449,8.444,5.822,9.222a1.586,1.586,0,0,1,.07,1.57,31.609,31.609,0,0,0-1.951,4.708,1.586,1.586,0,0,1-1.16,1.061L3.673,98.788v11.946l10.638,2.4a1.587,1.587,0,0,1,1.16,1.061,30.993,30.993,0,0,0,1.955,4.7,1.587,1.587,0,0,1-.069,1.575L11.529,129.7l8.449,8.444,9.223-5.823a1.586,1.586,0,0,1,1.575-.068,31.015,31.015,0,0,0,4.7,1.955,1.586,1.586,0,0,1,1.061,1.16l2.4,10.638H50.891l2.4-10.637a1.585,1.585,0,0,1,1.061-1.16,30.609,30.609,0,0,0,4.694-1.954,1.586,1.586,0,0,1,2.139.678Zm7.217-28.169A23.533,23.533,0,0,1,50.9,127.483a1.58,1.58,0,0,1-.707.175,23.585,23.585,0,0,1-10.55,0h-.028a1.581,1.581,0,0,1-.776-.2,23.492,23.492,0,1,1,29.572-22.692ZM44.915,125.083a20.347,20.347,0,0,0,3.666-.332v-7.9a1.59,1.59,0,0,1,.962-1.46A11.795,11.795,0,0,0,51.76,94.971v10.166a1.59,1.59,0,0,1-1.589,1.589H39.611a1.59,1.59,0,0,1-1.589-1.589V94.97a11.8,11.8,0,0,0,2.216,20.424,1.59,1.59,0,0,1,.963,1.461v7.886a20.37,20.37,0,0,0,3.715.341Zm20.319-20.319a20.319,20.319,0,1,0-27.212,19.114v-6.017A14.973,14.973,0,0,1,38.985,90.8,1.59,1.59,0,0,1,41.2,92.261v11.287h7.38V92.261A1.589,1.589,0,0,1,50.8,90.8a14.973,14.973,0,0,1,.962,27.061V123.9a20.354,20.354,0,0,0,13.474-19.132Zm50.283-19.609L85.752,136.71a1.586,1.586,0,0,1-.5.531L67.566,148.915a1.586,1.586,0,0,1-2.457-1.419l1.271-21.154a1.585,1.585,0,0,1,.21-.7L96.356,74.089A7.363,7.363,0,0,1,106.4,71.4l6.423,3.713a7.363,7.363,0,0,1,2.693,10.046ZM81.362,136.007l-11.969-6.912-.927,15.425ZM108.95,90.185,95.282,82.294,70.13,125.857,83.8,133.75Zm2.288-12.329h0l-6.422-3.712A4.187,4.187,0,0,0,99.1,75.675l-2.235,3.871,13.668,7.891,2.234-3.869a4.186,4.186,0,0,0-1.532-5.713Z"
          transform="translate(-0.501 -60.35)" fill="url(#linear-gradient)" />
      </svg>

      <h2>Easy Customization</h2>
    </div>
    <div class="grid-item">
      <svg id="Group_27" data-name="Group 27" xmlns="http://www.w3.org/2000/svg"
        xmlns:xlink="http://www.w3.org/1999/xlink" width="98.798" height="87.168" viewBox="0 0 98.798 87.168">
        <defs>
          <linearGradient id="linear-gradient" x1="0.5" x2="0.5" y2="1" gradientUnits="objectBoundingBox">
            <stop offset="0" stop-color="#1228c7" />
            <stop offset="1" stop-color="#f45af2" />
          </linearGradient>
        </defs>
        <path id="Path_88" data-name="Path 88"
          d="M128.427,181.563a1.631,1.631,0,0,0-2.3-.185l-10.554,8.987a1.632,1.632,0,0,0,0,2.484l10.554,8.987a1.631,1.631,0,0,0,2.115-2.483l-9.095-7.746,9.1-7.746a1.632,1.632,0,0,0,.184-2.3Zm0,0"
          transform="translate(-88.203 -138.816)" fill="url(#linear-gradient)" />
        <path id="Path_89" data-name="Path 89"
          d="M262.949,190.365,252.4,181.378a1.631,1.631,0,0,0-2.115,2.484l9.095,7.746-9.095,7.746a1.631,1.631,0,0,0,2.115,2.483l10.554-8.987a1.632,1.632,0,0,0,0-2.484Zm0,0"
          transform="translate(-191.521 -138.815)" fill="url(#linear-gradient)" />
        <path id="Path_90" data-name="Path 90"
          d="M197.5,153.06a1.632,1.632,0,0,0-1.932,1.261l-6.578,31.231a1.631,1.631,0,1,0,3.192.673l6.578-31.232a1.631,1.631,0,0,0-1.26-1.932Zm0,0"
          transform="translate(-144.925 -117.368)" fill="url(#linear-gradient)" />
        <path id="Path_91" data-name="Path 91"
          d="M87.846,0H10.952A10.963,10.963,0,0,0,0,10.952V76.217A10.964,10.964,0,0,0,10.952,87.168H87.846A10.964,10.964,0,0,0,98.8,76.217V10.952A10.963,10.963,0,0,0,87.846,0ZM10.952,3.262H87.846a7.7,7.7,0,0,1,7.689,7.689V22.857H3.262V10.952a7.7,7.7,0,0,1,7.689-7.689ZM87.846,83.906H10.952a7.7,7.7,0,0,1-7.689-7.689v-50.1H95.536v50.1A7.7,7.7,0,0,1,87.846,83.906Zm0,0"
          fill="url(#linear-gradient)" />
        <path id="Path_92" data-name="Path 92"
          d="M102.847,44.613h.015a5.162,5.162,0,0,0,.016-10.324h-.016a5.162,5.162,0,0,0-.016,10.323ZM101.524,38.1a1.889,1.889,0,0,1,1.339-.552h.006a1.9,1.9,0,0,1-.006,3.8h-.005a1.9,1.9,0,0,1-1.333-3.248Zm0,0"
          transform="translate(-74.994 -26.299)" fill="url(#linear-gradient)" />
        <path id="Path_93" data-name="Path 93"
          d="M34.568,44.528h.016a5.143,5.143,0,1,0-.016,0Zm.016-7.061h.006a1.9,1.9,0,0,1-.006,3.8h-.005a1.9,1.9,0,0,1,.005-3.8Zm0,0"
          transform="translate(-22.575 -26.263)" fill="url(#linear-gradient)" />
        <path id="Path_94" data-name="Path 94"
          d="M170.746,44.828h.016a5.162,5.162,0,0,0,.015-10.324h-.016a5.162,5.162,0,0,0-.016,10.324Zm.016-7.061h.005a1.9,1.9,0,0,1-.005,3.8h-.006a1.9,1.9,0,0,1,.006-3.8Zm0,0"
          transform="translate(-127.032 -26.464)" fill="url(#linear-gradient)" />
      </svg>
      <h2>Easy Shortcode Generation</h2>
    </div>
    <div class="grid-item">
      <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="89.828" height="87.438"
        viewBox="0 0 89.828 87.438">
        <defs>
          <linearGradient id="linear-gradient" x1="0.5" x2="0.5" y2="1" gradientUnits="objectBoundingBox">
            <stop offset="0" stop-color="#1228c7" />
            <stop offset="1" stop-color="#f45af2" />
          </linearGradient>
        </defs>
        <g id="_7-3" transform="translate(-5.086 -6.281)">
          <path id="Path_95" data-name="Path 95"
            d="M36.526,34.084A1.086,1.086,0,0,1,35.44,35.17H27.877a1.086,1.086,0,1,1,0-2.172H35.44A1.086,1.086,0,0,1,36.526,34.084ZM24.549,33a1.086,1.086,0,1,0,1.086,1.086A1.086,1.086,0,0,0,24.549,33ZM35.44,45.833H27.877a1.086,1.086,0,1,0,0,2.172H35.44a1.086,1.086,0,1,0,0-2.172Zm-10.891,0a1.086,1.086,0,1,0,1.086,1.086A1.086,1.086,0,0,0,24.549,45.833ZM35.44,58.668H27.877a1.086,1.086,0,1,0,0,2.172H35.44a1.086,1.086,0,0,0,0-2.172Zm-10.891,0a1.086,1.086,0,1,0,1.086,1.086A1.086,1.086,0,0,0,24.549,58.668Zm18.989-24.1a1.086,1.086,0,1,0,1.086,1.086A1.086,1.086,0,0,0,43.538,34.566Zm4.41,0a1.086,1.086,0,1,0,1.086,1.086A1.086,1.086,0,0,0,47.948,34.566Zm4.409,0a1.086,1.086,0,1,0,1.086,1.086A1.086,1.086,0,0,0,52.357,34.566ZM33.973,85.235H28.294a1,1,0,0,0,0,2h5.679a1,1,0,0,0,0-2ZM13.264,17.851a3.393,3.393,0,1,1,3.393-3.393A3.4,3.4,0,0,1,13.264,17.851Zm0-2a1.393,1.393,0,1,0-1.393-1.393A1.395,1.395,0,0,0,13.264,15.851Zm81.65,18.562V65.26a4.47,4.47,0,0,1-4.465,4.465H57.18V86.4a7.33,7.33,0,0,1-7.321,7.322H12.408A7.331,7.331,0,0,1,5.086,86.4V13.6a7.331,7.331,0,0,1,7.322-7.322H49.859A7.33,7.33,0,0,1,57.18,13.6V29.949H90.449a4.47,4.47,0,0,1,4.465,4.465Zm-4.465-2.465H42.994a2.468,2.468,0,0,0-2.465,2.465v4.941H92.914V34.413a2.468,2.468,0,0,0-2.465-2.465ZM55.18,86.4V80.75H7.086V86.4a5.327,5.327,0,0,0,5.322,5.322H49.859A5.327,5.327,0,0,0,55.18,86.4Zm0-16.672H42.994a4.47,4.47,0,0,1-4.465-4.465V34.413a4.47,4.47,0,0,1,4.465-4.465H55.18V13.6a5.327,5.327,0,0,0-5.321-5.322H12.408A5.327,5.327,0,0,0,7.086,13.6V78.75H55.18V69.726ZM92.914,65.26V41.354H40.529V65.26a2.468,2.468,0,0,0,2.465,2.465H90.449A2.468,2.468,0,0,0,92.914,65.26ZM19.055,19.477H43.211a3.434,3.434,0,0,1,0,6.868H19.055a3.434,3.434,0,0,1,0-6.868Zm-1.434,3.434a1.435,1.435,0,0,0,1.434,1.434H43.211a1.434,1.434,0,0,0,0-2.868H19.055a1.436,1.436,0,0,0-1.434,1.434ZM51.209,48.393a3.439,3.439,0,0,1,3.434-3.434H78.8a3.434,3.434,0,0,1,0,6.868H54.643a3.438,3.438,0,0,1-3.434-3.434Zm2,0a1.436,1.436,0,0,0,1.434,1.434H78.8a1.434,1.434,0,0,0,0-2.868H54.643a1.435,1.435,0,0,0-1.434,1.434ZM21.459,34.085a4.838,4.838,0,1,1-4.838-4.838A4.844,4.844,0,0,1,21.459,34.085Zm-2,0a2.838,2.838,0,1,0-2.838,2.838A2.841,2.841,0,0,0,19.459,34.085Zm2,12.835a4.838,4.838,0,1,1-4.838-4.838A4.844,4.844,0,0,1,21.459,46.92Zm-2,0a2.838,2.838,0,1,0-2.838,2.838A2.841,2.841,0,0,0,19.459,46.92Zm2,12.835a4.838,4.838,0,1,1-4.838-4.838A4.844,4.844,0,0,1,21.459,59.755Zm-2,0a2.838,2.838,0,1,0-2.838,2.838A2.841,2.841,0,0,0,19.459,59.755Zm39.265.3a4.838,4.838,0,1,1-4.838-4.838,4.844,4.844,0,0,1,4.838,4.838Zm-2,0a2.838,2.838,0,1,0-2.838,2.838A2.841,2.841,0,0,0,56.724,60.053Zm14.835,0a4.838,4.838,0,1,1-4.838-4.838,4.844,4.844,0,0,1,4.838,4.838Zm-2,0a2.838,2.838,0,1,0-2.838,2.838A2.841,2.841,0,0,0,69.559,60.053Zm14.835,0a4.838,4.838,0,1,1-4.838-4.838,4.844,4.844,0,0,1,4.838,4.838Zm-2,0a2.838,2.838,0,1,0-2.838,2.838A2.841,2.841,0,0,0,82.394,60.053Z"
            fill="url(#linear-gradient)" />
        </g>
      </svg>

      <h2>All Page Builder Compatibility</h2>
    </div>
    <div class="grid-item">
      <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="88.281" height="87.168"
        viewBox="0 0 88.281 87.168">
        <defs>
          <linearGradient id="linear-gradient" x1="0.5" x2="0.5" y2="1" gradientUnits="objectBoundingBox">
            <stop offset="0" stop-color="#1228c7" />
            <stop offset="1" stop-color="#f45af2" />
          </linearGradient>
        </defs>
        <path id="Path_96" data-name="Path 96"
          d="M79.706,89.5l-2.878-.615a2.657,2.657,0,0,0-2.453.706l-.363.355a12.435,12.435,0,0,1-4.026-4.027l.351-.356a2.65,2.65,0,0,0,.714-2.459l-.621-2.882A2.679,2.679,0,0,0,67.8,78.091H64.33a2.639,2.639,0,0,0-1.988.878,2.672,2.672,0,0,0-.7,2.056A18.981,18.981,0,0,0,63.7,88.117a1.247,1.247,0,0,0-1.615,1.19v7.361a1.246,1.246,0,0,0,2.492,0V89.636A18.964,18.964,0,0,0,78.9,98.282q.134.013.266.012a2.64,2.64,0,0,0,1.8-.709,2.668,2.668,0,0,0,.872-1.987V92.132A2.679,2.679,0,0,0,79.706,89.5Zm-.361,6.1a.162.162,0,0,1-.058.145.165.165,0,0,1-.157.058H79.12A16.477,16.477,0,0,1,64.128,80.812a.206.206,0,0,1,.2-.229H67.8a.192.192,0,0,1,.2.162l.621,2.882a.172.172,0,0,1-.053.184L67.549,84.84a1.246,1.246,0,0,0-.215,1.455,14.938,14.938,0,0,0,6.3,6.3,1.246,1.246,0,0,0,1.451-.214l1.03-1.01a.174.174,0,0,1,.188-.054l2.878.615a.192.192,0,0,1,.163.2V95.6ZM77.977,77.2a.624.624,0,0,0-.626-.621H75.48a1.246,1.246,0,0,1,0-2.492h1.872a3.179,3.179,0,0,1,0,6.356.627.627,0,0,0-.626.626v.747h2.5a1.246,1.246,0,0,1,0,2.492H75.48a1.246,1.246,0,0,1-1.246-1.246V81.068a3.121,3.121,0,0,1,3.118-3.118C77.932,77.95,77.977,77.374,77.977,77.2Zm7.094,3.244H82.5A1.246,1.246,0,0,1,81.272,79l.615-3.865a1.246,1.246,0,1,1,2.461.392l-.386,2.423h1.108V75.331a1.246,1.246,0,0,1,2.492,0v7.729a1.246,1.246,0,1,1-2.492,0ZM42.206,89.307v7.361a1.246,1.246,0,0,1-2.492,0V89.307a1.246,1.246,0,0,1,2.492,0Zm11.18,0A1.244,1.244,0,1,1,52.14,88.06,1.249,1.249,0,0,1,53.386,89.307Zm0-5.535a1.244,1.244,0,1,1-1.246-1.246A1.249,1.249,0,0,1,53.386,83.772Zm0,11.074A1.244,1.244,0,1,1,52.14,93.6,1.249,1.249,0,0,1,53.386,94.846ZM96.281,62.461V48.072a1.246,1.246,0,0,0-.987-1.219L87.02,45.093,84,37.8,88.608,30.7a1.246,1.246,0,0,0-.164-1.56L78.268,18.968a1.246,1.246,0,0,0-1.559-.164l-7.1,4.608-7.3-3.025-1.756-8.274a1.246,1.246,0,0,0-1.219-.987H44.946a1.246,1.246,0,0,0-1.219.987l-1.761,8.274-7.3,3.025L27.578,18.8a1.246,1.246,0,0,0-1.56.164L15.842,29.144a1.246,1.246,0,0,0-.164,1.56L20.286,37.8l-3.02,7.295L8.987,46.853A1.246,1.246,0,0,0,8,48.072V62.461a1.246,1.246,0,0,0,.987,1.219l8.279,1.761,3.02,7.295-4.608,7.094a1.246,1.246,0,0,0,.164,1.56L26.018,91.565a1.246,1.246,0,0,0,1.559.164L32,88.86v7.807a1.246,1.246,0,0,0,2.492,0V80.483c0-3.813,4.439-6.175,9.329-7.337L46.215,81.1a1.246,1.246,0,0,0,2.019.574l4.189-3.708,4.184,3.708a1.246,1.246,0,0,0,2.019-.573l2.381-7.912a22.229,22.229,0,0,1,4.593,1.56,1.246,1.246,0,0,0,2.407.633A13.194,13.194,0,1,1,84.543,91.921a1.246,1.246,0,1,0,.742,2.379,15.683,15.683,0,0,0,2.337-28.988l7.671-1.632a1.246,1.246,0,0,0,.987-1.218ZM48.04,78.521l-1.762-5.856q.449-.07.9-.127l3.463,3.685Zm-6.416-16.4H40.6a2.707,2.707,0,0,1-.108-5.412h0a20.211,20.211,0,0,0,1.093,5.282c.013.043.026.086.042.129Zm12.928,5.726a.7.7,0,0,1-.7-.7.706.706,0,0,1,.7-.7h2.129a.7.7,0,0,1,0,1.393Zm6.806-13.632h-.611c-4.068,0-7.077-1.316-10.344-3.291a1.246,1.246,0,0,0-1.173-.062L42.938,53.8V52.608a9.21,9.21,0,0,1,18.421,0Zm.2,10.4H62.69v.111A1.182,1.182,0,0,1,61.509,65.9h-.763A14.5,14.5,0,0,0,61.555,64.61Zm2.124-2.492h-1c.008-.022.014-.044.021-.067a20.313,20.313,0,0,0,1.1-5.337l0-.008a2.707,2.707,0,0,1-.13,5.411Zm1.146-7.777a5.182,5.182,0,0,0-.974-.124V52.608a11.7,11.7,0,0,0-23.4,0v1.608a5.18,5.18,0,0,0-.974.12V52.608a12.676,12.676,0,0,1,25.353,0v1.733ZM49.69,53.395A20.7,20.7,0,0,0,60.748,56.7h.562A15.951,15.951,0,0,1,58.6,64.609a3.168,3.168,0,0,0-1.921-.649H54.552A3.188,3.188,0,0,0,51.5,68.082c-5.771-.446-8.2-6.847-8.528-11.547Zm2.461,17.2a10.286,10.286,0,0,0,2.32-.266c.027,0,.054,0,.081,0h1.337v.455l-3.467,3.693-3.471-3.694V70.1A10.218,10.218,0,0,0,52.151,70.6ZM56.8,78.52l-2.592-2.3,3.4-3.627q.472.059.932.129Zm9.713-6.09a28.5,28.5,0,0,0-8.133-2.245V69.84a3.206,3.206,0,0,0,1.235-1.447H61.51a3.677,3.677,0,0,0,3.673-3.673v-.334A5.2,5.2,0,0,0,67.316,55.7V52.607a15.168,15.168,0,0,0-30.337,0v3.075A5.2,5.2,0,0,0,40.6,64.61h2.137v-.025c.12.218.242.433.37.64a11.992,11.992,0,0,0,3.356,3.637v1.257a26.211,26.211,0,0,0-9.522,2.972c-.373.218-.723.445-1.055.68A24.632,24.632,0,1,1,74.9,64.712a15.659,15.659,0,0,0-3.68,2.044,15.846,15.846,0,0,0-4.708,5.674ZM93.789,61.452l-7.928,1.687a1.246,1.246,0,0,0-.892.742l-.143.345a15.648,15.648,0,0,0-4.231-.58,15.853,15.853,0,0,0-2.722.237A27.134,27.134,0,1,0,34,75.433a7.454,7.454,0,0,0-2,5.049v5.408l-4.933,3.2-8.75-8.75,4.415-6.8a1.246,1.246,0,0,0,.106-1.155l-3.522-8.506a1.246,1.246,0,0,0-.892-.742l-7.933-1.687V49.081l7.933-1.687a1.246,1.246,0,0,0,.892-.742l3.522-8.506a1.246,1.246,0,0,0-.106-1.155l-4.415-6.8,8.749-8.749,6.8,4.415a1.246,1.246,0,0,0,1.156.106l8.506-3.527a1.246,1.246,0,0,0,.741-.892l1.687-7.928H58.331l1.682,7.928a1.246,1.246,0,0,0,.742.892l8.506,3.527a1.246,1.246,0,0,0,1.155-.106l6.8-4.415,8.75,8.75-4.415,6.8a1.246,1.246,0,0,0-.106,1.155l3.522,8.506a1.246,1.246,0,0,0,.892.742l7.927,1.687Z"
          transform="translate(-8 -11.126)" fill="url(#linear-gradient)" />
      </svg>

      <h2>24/7 Professional Support</h2>
    </div>
    <div class="grid-item">
      <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="105.354" height="86.238"
        viewBox="0 0 105.354 86.238">
        <defs>
          <linearGradient id="linear-gradient" x1="0.5" x2="0.5" y2="1" gradientUnits="objectBoundingBox">
            <stop offset="0" stop-color="#1228c7" />
            <stop offset="1" stop-color="#f45af2" />
          </linearGradient>
        </defs>
        <g id="Layer_2_00000079458615077401466370000003489663907794615738_" transform="translate(0 -46.5)">
          <g id="Layer_1-2" transform="translate(0 46.5)">
            <path id="responsive_web_design"
              d="M99.387,86.193H97.638V53.558A7.069,7.069,0,0,0,90.58,46.5H28.725a7.069,7.069,0,0,0-7.058,7.058V76.769H8a8,8,0,0,0-8,7.984v39.981a8,8,0,0,0,8,8H31.4a8,8,0,0,0,8-8V105.8H50.948v7.387H46.092a1.6,1.6,0,0,0,0,3.189H73.233a1.6,1.6,0,0,0,0-3.189H68.4V105.8H80.353v12.14a6.007,6.007,0,0,0,5.988,5.988H99.387a5.976,5.976,0,0,0,5.967-5.988V92.16a5.972,5.972,0,0,0-5.967-5.967ZM24.878,53.558a3.855,3.855,0,0,1,3.848-3.848H90.58a3.886,3.886,0,0,1,3.868,3.848V86.172H86.32a6.06,6.06,0,0,0-6.008,6.091,3.334,3.334,0,0,0,.021.453H39.384v-8a8,8,0,0,0-8-8h-6.5Zm11.276,71.176a4.782,4.782,0,0,1-4.794,4.774H8a4.782,4.782,0,0,1-4.794-4.774V84.753A4.769,4.769,0,0,1,8,79.979H31.4a4.812,4.812,0,0,1,4.794,4.794ZM65.188,113.19H54.117V105.8H65.208Zm1.605-10.577H39.384V95.926H80.353v6.688Zm35.351,15.33a2.811,2.811,0,0,1-2.778,2.8H86.32a2.784,2.784,0,0,1-2.778-2.8V92.16a2.779,2.779,0,0,1,2.778-2.778H99.387a2.766,2.766,0,0,1,2.778,2.778Z"
              transform="translate(0 -46.5)" fill="url(#linear-gradient)" />
          </g>
        </g>
      </svg>

      <h2>Responsive Design</h2>
    </div>


  </div>
  <br>
  <div class="container-div">
    <div class="row justify-content-between">
      <div class="col-lg-5 col-md-5 col-12">
        <div class="requirement">
          <h4>System Requirements</h4>
          <ul>
    <li>
        <div class="check">
            <img src="<?php echo esc_url(OVA_ELEMS_URL . 'assets/images/check-img.png'); ?>" alt="">
            PHP Version: Currently: 8.1.27
        </div>
    </li>
    <li>
        <div class="check">
            <img src="<?php echo esc_url(OVA_ELEMS_URL . 'assets/images/check-img.png'); ?>" alt="">
            Max execution time: Currently: 480
        </div>
    </li>
    <li>
        <div class="check">
            <img src="<?php echo esc_url(OVA_ELEMS_URL . 'assets/images/check-img.png'); ?>" alt="">
            Memory Limit: Currently: 12288M
        </div>
    </li>
    <li>
        <div class="check">
            <img src="<?php echo esc_url(OVA_ELEMS_URL . 'assets/images/check-img.png'); ?>" alt="">
            Max Post Limit: Currently: 12288M
        </div>
    </li>
</ul>

        </div>
      </div>
      <div class="col-lg-7 col-md-7 col-12">
        <div class="bundle-wrapper">
          <h2>WORDPRESS THEME BUNDLE</h2>
          <p class="bundle-text">Access 125+ Gutenberg Block WordPress themes</p>
          <div class="bundle-image">
          <a href="<?php echo esc_url('https://www.ovationthemes.com/products/wordpress-bundle?via=true-parameter'); ?>" target="_blank"><img src="<?php echo esc_url(OVA_ELEMS_URL . 'assets/images/bundle-images.png'); ?>" alt=""></a>

          </div>
        </div>
      </div>
    </div>
  </div>
  <br>
  <div class="main-grid" id="gird-bottom">
    <div class="grid-item item-1">
      <svg xmlns="http://www.w3.org/2000/svg" width="264.277" height="116.764" viewBox="0 0 264.277 116.764">
        <g id="Group_10" data-name="Group 10" transform="translate(0 -142.893)">
          <path id="Path_31" data-name="Path 31"
            d="M445.6,171.8a3.646,3.646,0,0,0-2.021-6.219L425.835,163a3.645,3.645,0,0,1-2.745-1.994l-7.938-16.083a3.646,3.646,0,0,0-6.539,0l-7.938,16.083A3.646,3.646,0,0,1,397.931,163l-17.749,2.579a3.646,3.646,0,0,0-2.021,6.219L391,184.321a3.647,3.647,0,0,1,1.049,3.227l-3.032,17.678a3.646,3.646,0,0,0,5.29,3.843l15.875-8.346a3.645,3.645,0,0,1,3.393,0l15.875,8.346a3.646,3.646,0,0,0,5.29-3.843l-3.032-17.678a3.646,3.646,0,0,1,1.049-3.227Z"
            transform="translate(-182.433 0)" fill="#fee55a" />
          <path id="Path_32" data-name="Path 32"
            d="M410.132,193.2a3.646,3.646,0,0,0-1.049-3.227L396.24,177.454a3.646,3.646,0,0,1,2.02-6.219l17.749-2.579a3.645,3.645,0,0,0,2.745-1.994l3.562-7.218-7.165-14.518a3.646,3.646,0,0,0-6.539,0l-7.938,16.083A3.646,3.646,0,0,1,397.929,163l-17.749,2.579a3.646,3.646,0,0,0-2.02,6.219L391,184.321a3.646,3.646,0,0,1,1.049,3.227l-3.032,17.678a3.646,3.646,0,0,0,5.29,3.843l14.4-7.569Z"
            transform="translate(-182.432 0)" fill="#ffd301" />
          <path id="Path_33" data-name="Path 33"
            d="M1.105,171.8a3.646,3.646,0,0,1,2.021-6.219L20.875,163a3.645,3.645,0,0,0,2.745-1.994l7.938-16.083a3.646,3.646,0,0,1,6.539,0l7.938,16.083A3.646,3.646,0,0,0,48.779,163l17.749,2.579a3.646,3.646,0,0,1,2.021,6.219L55.705,184.321a3.646,3.646,0,0,0-1.049,3.227l3.032,17.678a3.646,3.646,0,0,1-5.29,3.843l-15.875-8.346a3.645,3.645,0,0,0-3.393,0l-15.875,8.346a3.646,3.646,0,0,1-5.29-3.843L15,187.548a3.646,3.646,0,0,0-1.049-3.227Z"
            transform="translate(0 0)" fill="#fee55a" />
          <path id="Path_34" data-name="Path 34"
            d="M28.911,191.714a3.646,3.646,0,0,0-1.048-3.227L15.02,175.968a3.646,3.646,0,0,1,2.021-6.218l17.749-2.579a3.645,3.645,0,0,0,2.745-1.994l5.278-10.694L38.1,144.927a3.646,3.646,0,0,0-6.539,0L23.62,161.01A3.646,3.646,0,0,1,20.875,163L3.126,165.584a3.646,3.646,0,0,0-2.02,6.219l12.843,12.519A3.645,3.645,0,0,1,15,187.549l-3.032,17.678a3.646,3.646,0,0,0,5.29,3.843l9.539-5.015Z"
            transform="translate(0 0)" fill="#ffd301" />
          <path id="Path_35" data-name="Path 35"
            d="M363.163,191.653a4.477,4.477,0,0,0-2.481-7.637l-21.8-3.167a4.478,4.478,0,0,1-3.371-2.449l-9.748-19.751a4.477,4.477,0,0,0-8.03,0L307.988,178.4a4.476,4.476,0,0,1-3.371,2.449l-21.8,3.167a4.477,4.477,0,0,0-2.481,7.637l15.772,15.374a4.477,4.477,0,0,1,1.288,3.963L293.675,232.7a4.477,4.477,0,0,0,6.5,4.72l19.5-10.249a4.475,4.475,0,0,1,4.166,0l19.5,10.249a4.477,4.477,0,0,0,6.5-4.72L346.1,210.989a4.476,4.476,0,0,1,1.288-3.963Z"
            transform="translate(-134.981 -6.415)" fill="#fee55a" />
          <path id="Path_36" data-name="Path 36"
            d="M315.346,216.455a4.476,4.476,0,0,0-1.288-3.963l-15.772-15.374a4.477,4.477,0,0,1,2.481-7.637l21.8-3.167a4.478,4.478,0,0,0,3.371-2.449l6.138-12.437-6.307-12.779a4.477,4.477,0,0,0-8.029,0L307.989,178.4a4.476,4.476,0,0,1-3.371,2.449l-21.8,3.167a4.477,4.477,0,0,0-2.481,7.637l15.772,15.374a4.477,4.477,0,0,1,1.288,3.963L293.676,232.7a4.477,4.477,0,0,0,6.5,4.72l12.726-6.69Z"
            transform="translate(-134.981 -6.416)" fill="#ffd301" />
          <path id="Path_37" data-name="Path 37"
            d="M68.658,191.653a4.477,4.477,0,0,1,2.481-7.637l21.8-3.167a4.478,4.478,0,0,0,3.371-2.449l9.748-19.751a4.477,4.477,0,0,1,8.03,0l9.748,19.751a4.476,4.476,0,0,0,3.371,2.449l21.8,3.167a4.477,4.477,0,0,1,2.481,7.637L135.71,207.027a4.477,4.477,0,0,0-1.288,3.963l3.724,21.709a4.477,4.477,0,0,1-6.5,4.72l-19.5-10.249a4.475,4.475,0,0,0-4.166,0l-19.5,10.249a4.477,4.477,0,0,1-6.5-4.72l3.724-21.709a4.476,4.476,0,0,0-1.288-3.963Z"
            transform="translate(-32.562 -6.415)" fill="#fee55a" />
          <path id="Path_38" data-name="Path 38"
            d="M105.569,216.455a4.476,4.476,0,0,0-1.288-3.963L88.509,197.119a4.477,4.477,0,0,1,2.481-7.637l21.8-3.167a4.478,4.478,0,0,0,3.371-2.449l5.185-10.506-7.259-14.709a4.477,4.477,0,0,0-8.03,0L96.306,178.4a4.475,4.475,0,0,1-3.371,2.449l-21.8,3.167a4.477,4.477,0,0,0-2.481,7.637l15.772,15.374a4.477,4.477,0,0,1,1.288,3.963L81.993,232.7a4.477,4.477,0,0,0,6.5,4.72l14.82-7.791Z"
            transform="translate(-32.562 -6.416)" fill="#ffd301" />
          <path id="Path_39" data-name="Path 39"
            d="M257.689,212.077a5.718,5.718,0,0,0-3.169-9.753l-27.837-4.045a5.718,5.718,0,0,1-4.305-3.128l-12.449-25.224a5.718,5.718,0,0,0-10.255,0l-12.449,25.224a5.718,5.718,0,0,1-4.305,3.128l-27.837,4.045a5.718,5.718,0,0,0-3.169,9.753l20.143,19.634a5.718,5.718,0,0,1,1.645,5.061L168.946,264.5a5.718,5.718,0,0,0,8.3,6.027l24.9-13.089a5.716,5.716,0,0,1,5.321,0l24.9,13.089a5.718,5.718,0,0,0,8.3-6.027L235.9,236.773a5.718,5.718,0,0,1,1.645-5.061Z"
            transform="translate(-72.663 -11.537)" fill="#fee55a" />
          <path id="Path_40" data-name="Path 40"
            d="M200.111,244.394a5.718,5.718,0,0,0-1.645-5.061L178.324,219.7a5.718,5.718,0,0,1,3.169-9.753l27.837-4.045a5.718,5.718,0,0,0,4.305-3.128l6.252-12.668-9.958-20.178a5.718,5.718,0,0,0-10.255,0l-12.449,25.224a5.717,5.717,0,0,1-4.305,3.128l-27.837,4.045a5.718,5.718,0,0,0-3.169,9.753l20.143,19.634a5.717,5.717,0,0,1,1.645,5.061L168.945,264.5a5.718,5.718,0,0,0,8.3,6.027L197.451,259.9Z"
            transform="translate(-72.662 -11.537)" fill="#ffd301" />
        </g>
      </svg>

    </div>

    <div class="grid-item item-2">
      <h2>LEAVE US YOUR FEEDBACK</h2>
      <p>We value your feedback and are always looking to improve our plugin.</p>
    </div>
    <div class="grid-item item-3">

      <a href="<?php echo esc_url('https://wordpress.org/support/plugin/ovation-elements/'); ?>" class="button review-button" target="_blank" rel="noopener noreferrer">Review
        Now</a>
    </div>
  </div>

</body>